<?php


	# pagepost.php - Create or save a page


	#login
	include_once 'data_connect.php';
	include 'log.php';
	include 'en_code.php';



	# user rights- admins only
	if (get_account($_SESSION['userID'])['rights'] != 'administrator')	
		exit('You cannot edit this page');
	
	


	
	# POST values: uniqueid, title, description, content, filename, path



	# Create a page
	if (isset($_POST['uniqueid']))	{
		
		
		$p = $_POST;

		$page = $p['uniqueid'].'.xml';
		$pagexml = simplexml_object($page,'l','page');
		$xml_struc = '<?xml version="1.0" encoding="utf-8"?><savedpage><title>Saved Page</title><pageinfo></pageinfo></savedpage>';

			
		
		# clean filename from unwanted characters
		$filename = str_replace(['&','/',' ','$','+',',',':',';','=','?','@','<','>','#','%','{','}','|','^','~','[',']','`','\\','\'','"'],'',$p['filename']);
		$filename = str_replace(["\n","\r"],"",$filename);
		
		
		# clean path
		$pd = $p['catalogue'];
		$pagedir = str_replace([" ","\n","\r"],["-","",""],$pd);
		$pagedir = preg_replace('/\/\/+/', '/',$pagedir);
		$pagedir = mb_strtolower($pagedir,'UTF-8');
		
		
					
		# second clean of filename and path, based on xml file
		$denylist = simplexml_object('pages_na.xml','l',null);
		if ($denylist == ['missingfile']) {
		
			file_put_contents('filesinfo/pages_na.xml','<?xml version="1.0" encoding="utf-8"?><pagesna><pagefilename></pagefilename><pagefolder>..</pagefolder><pagefolder>.</pagefolder><pagefolder></pagefolder><pagefolder>monofiles</pagefolder><pagefolder>index</pagefolder><pagefolder>pagep</pagefolder><catfoldername>.</catfoldername><catfoldername>..</catfoldername><catfoldername>monofiles</catfoldername><catfoldername></catfoldername></pagesna>');
			$na = ['pagefolder'=>['.','..','','monofiles','index','pagep'],'pagefilename'=>[]];
		}


		else
			foreach($denylist as $k=>$v)
				$na[$k][] = (string)$v;
			
		###		
		###
	
		# not allowed folder names
		$naf = $na['pagefolder'];
		$pagefolders = explode('/',$pagedir);
		$final = array_diff($pagefolders,$naf);
		$depth = count($final);



		$path = $incpath = '';
		# $path=folder1/folder2/folder3/  $incpath=../../../


		if ($depth > 0) {
			foreach ($final as $val)
				$path .= $val.'/';

			$incpath = str_repeat('../',$depth);
			if (!is_dir('../'.$path))
				mkdir('../'.$path,0777,true);
		}


		if (substr($path,0,10) == 'monofiles/')
			$path = str_replace(substr($path,0,10),'',$path);


		
		# not allowed file names
		$nan = $na['pagefilename'];
			
		# if not allowed to ovewrite, add '_' to filename
		if (in_array($filename,$nan) || (is_file('../'.$path.$filename.'.php') && (is_array($pagexml) || $path.$filename != $pagexml->pageinfo->page->path.$pagexml->pageinfo->page->filename)))
			$filename = '_'.$filename;
	
		elseif ($filename == '')
			$filename = !is_array($pagexml) ? $pagexml->pageinfo->page->filename : '_'.bin2hex(random_bytes(4));
		
		
		
		
		# if the filename has changed by the user, delete the old one and also delete the respective page
		if (!is_array($pagexml)) {
			
			$oldname = (string)$pagexml->pageinfo->page->filename;
			$oldpath = (string)$pagexml->pageinfo->page->path;

			if (($oldname != $filename || $oldpath != $pagedir) && is_file('../'.$oldpath.$oldname.'.php'))
				unlink('../'.$oldpath.$oldname.'.php');
		}
			

		
		
		### ## #
		
		# create file and update log
		if ($pagexml == ['missingfile']) {
			
			touch('savedpages/'.$page);
			$sum = get_log()['pages'];
			$sum += 1;
			update_log('pages',$sum);
		}
		
		$title = remove_tags($p['title']);
		$description = str_replace(["\n","\r",'"'],'',$p['description']);
		

		if (is_array($pagexml))
			$saved = new simpleXMLElement($xml_struc);
		else
			$saved = simplexml_object($page,'e','page');

		$saved->pageinfo->page->filename = $filename;
		$saved->pageinfo->page->title = $title;
		$saved->pageinfo->page->description = $description;
		$saved->pageinfo->page->editor = $_SESSION['userID'];
		$saved->pageinfo->page->path = $path;
		$saved->pageinfo->page->incpath = $incpath;
		$saved->pageinfo->page->modified = time();
		
		
		# 'Do not publish' checkbox. Only for new pages.
		if (isset($p['pagepub']))
			$saved->pageinfo->page->published = 'hidden';	
		else
			$saved->pageinfo->page->published = 'on';
		
		
		# save htm
		file_put_contents('savedpages/'.$p['uniqueid'].'.htm',str_replace(['<?','?>'],'',$p['content']));    
		
		
		
		# Save the page
		if ($saved->pageinfo->page->published != 'hidden') {
		
			$pagecontent ='<?php $pn = "'.$p['uniqueid'].'"; $incp = "'.$incpath.'"; include "'.$incpath.'monofiles/path.php" ?>';	
			$saved->pageinfo->page->lastmodpage = time();
			
			file_put_contents('../'.$path.$filename.'.php',$pagecontent);
			$visit = '<a href="../'.$path.$filename.'.php" target="_blank">Visit page</a>';
		
		}
		
			
		# Save xml
		simplexml_object_save($page,$saved,'page');
		
		
		# different messages for published and unpublished
		$visit = isset($visit) ? $visit : '<span>Not published</span>';
		echo 'Page saved - '.date("H:i",time()).'&nbsp;-&nbsp;'.$visit;
		
		
	}



		

?>
