<?php


	# Menu and page structure
	include_once 'data_connect.php';

	
	# Clear error buffer and disable errors
	libxml_clear_errors();
	libxml_use_internal_errors(true);
	
	
	# Enable the save button in these pages only
	$enabled = ['general.php','generaluser.php','advanced.php','category.php','account.php'];
	
	
	# Get the settings
	$xmls = getXMLSettings();

	
	# Account info 
	$log_info = get_log();
	
	if (!isset($acc_info))
		$acc_info = get_account($_SESSION['userID']);
	
	
	$monrights = $acc_info['rights'];
	$user = $_SESSION['username'];
	$urlicon = '../images/'.$acc_info['urlicon'];
	$usericon = is_file($urlicon) ? $urlicon : $acc_info['icon'];
	
	
	$c = $monrights == 'administrator' ? $log_info['posts'] : myPosts()[0];
	$d = $log_info['pages'];	
	
	
	
	
	# sidemenu info	
	$smenulink = '?sidemenu=1';
	foreach($_GET as $k=>$v)
		$smenulink .= '&'.$k.'='.$v;



	# included files
	$lgparam = (get_included_files())


	
?>
<div id="top">
	<!-- Left section -->
	<div class="editbar">

		<!-- logo -->
		<div class="logo">
			<a href="../" id="logolink" title="View website" target="_blank" ><?php print $xmls['title'] ?>&nbsp; <img src="images/openlink.png" class="logoimg"></a>
		</div>
		
		<div id="dropd">
			<span id="droph" tabindex="0">&hellip;</span>
		<?php 
		
			if ($acc_info['sidemenu'] == 'off') :
				print '<style>'		
		?>	
		#navcon{width:50px}
		#navelem{min-height:230px}
		#dropdown-content{width:86px;top:-800px;position:relative;height:auto;margin:0 0 0 4px;display:inline-block;background-color:#fbfbfb;padding:0 7px 16px 0}
		#dropd{position:relative;top:23px;display:block;float:left;margin-left: 12px;width:24px;height:24px}
		#droph{width:32px;height:28px;color:#111;margin-left:12px;text-align:center;padding-top:3px;border-radius:16px;display:block;float:left;cursor:pointer;outline:none}
		#droph:hover{background-color:#f6f6f6}
		.top16{top:42px!important;left:17px!important}
		.dropdown-title:focus{position:fixed;top:23px;margin-left:42px}
		.top16 .dropdown-title:focus{position:relative;top:0;margin-left:6px}
		.text{display:inline-block;font-size:13px;font-weight:bold;padding:0 2px;border-radius:4px;border-color:transparent !important}
		.dinf{font-size:12px;padding:2px 6px;position:relative;left:3px}
		.dpsub{display:none!important}
		.dropdown-title{height:15px;margin:0 0 0 6px;padding:4px;border-color:transparent!important;border-radius:4px!important}
		.clearmenu{height:8px}
		.main{margin-left:60px;max-width:90%}
		.sidesep{left:20px;height:50px}
		.menutog a span{width:7px;height:11px;border-left:4px solid}
		
		<?php 
		
		print $cssid.'{padding:2px;margin-left:8px}'.$cssid.':focus{margin-left:42px}';
		
		
		if ($acc_info['theme'] == 'dark')
			print '#dropdown-content{background-color:#161616}
					#droph{color:#eee}
					#droph:hover{background-color:#333}';
		
		print '</style>';
		
		endif
		
		
		 ?>
		
		<script>
		function openclmenu(e) {
			
			const mymenu = document.getElementById('dropdown-content');
			const mymbut = document.getElementById('droph');
			
			if (e.target.tagName == 'HTML')
				mymenu.removeAttribute('class');
				
			else if (e.target.className == 'text' || e.target.parentElement.id == 'dropdown-content' || e.target.parentElement.className == 'text')	
				mymenu.setAttribute('class','top16');
				
			 else if (e.target.id == 'droph') {
			 
				if (mymenu.hasAttribute('class'))
					mymenu.removeAttribute('class');
				else
					mymenu.setAttribute('class','top16');
				}
				
			else 
				mymenu.removeAttribute('class');
			
			}
			
			document.addEventListener('mousedown',function(e){
				
			openclmenu(e);
		
		});
		</script>
		</div>
	</div>
		
		
		
	<div id="navcon" tabindex="-1">
		<div id="navelem">
		
			<?php if ($acc_info['sidemenu'] == 'off') : ?>
			
			<div class="clear clearmenu sidesep">
				::
				<div class="menutog" title="Show/hide side menu"><a href="<?php print $smenulink ?>"><span></span></a></div>
			</div>
		</div>
	</div>
	<?php endif ?>
			<!-- Navigation menu -->		
			<div id="dropdown-content">
				<a href="opensaved.php" id="posts" class="dropdown-title" title="Posts"><span class="text">Posts<?php print '<span class="dinf">'.$c.'</span>' ?></span></a>
				<span class="dpsub"></span>
				<div class="clearmenu-s"></div>
				
				<?php if ($monrights == 'administrator') : ?>
				<a href="catmanage.php" id="categories" class="dropdown-title" title="Categories"><span class="text">Categories</span></a>
				<span class="dpsub"></span>
				<div class="clearmenu-s"></div>
				<?php else : ?>
				<a href="category.php" id="categories" class="dropdown-title" title="Add Categories"><span class="text">Add categories</span></a>
				<div class="clearmenu-s"></div>
				<?php endif ?>				
				<div class="clear clearmenu"></div>

				<?php if ($monrights == 'administrator') : ?>

				<a href="pages.php?showpub=1" id="allpages" class="dropdown-title" title="Pages"><span class="text">Pages<?php print '<span class="dinf">'.$d.'</span>' ?></span></a>
				<span class="dpsub"></span>
				<div class="clear clearmenu"></div>
				<a href="general.php" id="settings" class="dropdown-title" title="Settings"><span class="text">Settings</span></a>
				<span class="dpsub"></span>
				<div class="clearmenu-s"></div>
				<a href="accmanage.php" id="accounts" class="dropdown-title" title="User accounts"><span class="text">Accounts</span></a>
				<span class="dpsub"></span>
				<div class="clear clearmenu"></div>
				<a href="uploads.php" id="images" class="dropdown-title" title="Images"><span class="text">Images</span></a>
				<div class="clearmenu-s"></div>
				
				<?php else : ?>
				<a href="generaluser.php" id="settings" class="dropdown-title" title="Settings"><span class="text">Settings</span></a>
				<div class="clear clearmenu">
				</div>
				<a href="uploads.php" id="images" class="dropdown-title" title="Images"><span class="text">Images</span></a>
				<div class="clearmenu-s"></div>
				<?php endif ?>
			</div>
			
			<?php if ($acc_info['sidemenu'] != 'off') : ?>
			
		<div class="clear clearmenu sidesep">
				::
				<div class="menutog" title="Show/hide side menu"><a href="<?php print $smenulink ?>"><span></span></a></div>
			</div>
		</div>
	</div>
	<?php endif ?>
	<!-- Top right HOVER menu-->
	<div id="userinfo">
		<span class="panelicon" style="background-image:url('<?php print $usericon ?>')">
			<?php
					
				$enab = ' disabled';
				$tit = '';
				foreach(get_included_files() as $val) {
					$cscr = basename($val);
					if (in_array($cscr,$enabled)) {
						$enab = '';
						$tit = 'Save';
						break;
					}
				}
				
			?>
		</span>
		<div id="useradmin">
			<input id="general-submit" type="submit" value="Save" title="<?php print $tit ?>" onmouseout="this.blur()" name="submitted" form="MONform"<?php print $enab ?>>
			<a id="lgcon" href="?logout=1" title="Logout <?php print $user ?>" onmouseout="this.blur()">Logout</a>
			<span id="user" class="username" title="Username"><?php print $user ?></span>
		</div>
		
	</div>
</div>
