<?php

	
	# General settings
	


	# login
	include_once 'data_connect.php';
	include_once 'log.php';


	
	# user rights - admins only
	if (get_account($_SESSION['userID'])['rights'] != 'administrator') {
		header('Location:generaluser.php');
		exit;
	}

	
	# submit form data
	function submit_settings_values() {


		$save = simplexml_object('settings.xml','e',null);
		$website_title = strip_tags($_POST['title']);
		$website_description = htmlspecialchars(strip_tags($_POST['description']),ENT_COMPAT);
		$website_description = preg_replace('/ {2,}/',' ',$website_description);
		$website_title = preg_replace('/ {2,}/',' ',$website_title);
		
		
		$max = $_POST['maximagesize'] > 0 ? ltrim($_POST['maximagesize'],'0') : $_POST['maximagesize'];
		
		
		# Results per page
		$indexposts = ltrim($_POST['indexposts'],'0');
		
		if (strlen($indexposts) != strlen($_POST['indexposts']))
			$indexposts = '0'.$indexposts;
		
		if (!ctype_digit($max) || $max < 0 || $max > 20000)
			$error = 'ERROR:maximagesize';
				

		if (!ctype_digit($indexposts) || $indexposts < 0 || $indexposts > 1000 || strlen($_POST['indexposts']) > 6)
			$error = 'ERROR:indexposts';
		
				
				
		# excerpt limit accepts 0 and ''		
		if (isset($_POST['exclim'])) {
						
			
			for($i=1; $i<10; $i++)
				if (strpos($_POST['exclim'],(string)$i) !== false) {
					$_POST['exclim'] = ltrim($_POST['exclim'],0);
					break;
				}
			
			if (substr($_POST['exclim'],0,2) == '00')
				$_POST['exclim'] = '0';

		
		
		
			$exclimit = strlen($_POST['exclim']) > 1 ? preg_replace('/0*/','',str_replace(' ','',$_POST['exclim']),1) : (string)$_POST['exclim'];
			
			if ($exclimit != '' && (!ctype_digit($exclimit) || $exclimit < 0))
				$error = 'ERROR:exclimit';
			
			# save separately
			$save->general->exclimit = $exclimit;
		}
		
		
		
		
		
		# user related info - Update the POST[] values
		$_POST['urlicon'] = trim(basename($_POST['urlicon']));
		$_POST['usereditorname'] = preg_replace('/ {2,}/',' ',$_POST['usereditorname']);
		
		if (strlen($_POST['usereditorname']) > 40 || $_POST['usereditorname'] == ' ' || $_POST['usereditorname'] == '' )
			$error = 'ERROR:editorname';
		
		$userrelated = ['usereditorname','urlicon'];
		foreach ($userrelated as $user)
			$_POST[$user] = isset($_POST[$user]) ? strip_tags($_POST[$user]) : ' ';



		
		# settings values
		$on_off_values = ['togsign','togcategories','togtags','togreadold','togptitle','togexc','unidates','togreadmore','tagstext'];
		$textual_values = ['maximagesize'=>$max,'indexposts'=>$indexposts,'description'=>$website_description,'title'=>$website_title];
		$user_on_off = ['texteditor'];


		# ======		
		
		
		# administrator settings
		foreach($on_off_values as $onoff) {
			$val = isset($_POST[$onoff]) ? 'on' : 'off';
			$save->general->$onoff = $val;
		}
		
		
		foreach($textual_values as $key=>$val)
			
			if ($val != '')
				if ($key == 'indexposts')
					$save->general->$key->results = $val;
				else
					$save->general->$key = $val;

		
		
		
		
		
		# user on off settings
		foreach($user_on_off as $val)
			if (!isset($_POST[$val]))
				$_POST[$val] = 'off';


		if (!isset($error)) {
			
			if (isset($_POST['dateshow']))
				$save->general->dateshow = $_POST['dateshow'];
			
			$save->general->modified = time();
			
			simplexml_object_save('settings.xml',$save,null);
			
			update_account($_SESSION['userID'],'set');
			
			
			$_SESSION['settingsset'] = true;
		}

		else
			$_SESSION[$error] = true;

		
		header('Location:general.php');
		exit();
		
		return true;

	}



	if (isset($_POST['submitted']))
		submit_settings_values()
		

?>
<!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Settings</title>
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<?php
	$cssid = '#settings';
	include 'csstheme.php';
	print '<style>'.$curval.'</style>' ?>
</head>
<body>
<?php



	# panel
	include 'mypanel.php';
	


	# Load settings
	# textual values
	$website_title = $xmls['title'];
	$website_description = $wd = $xmls['description'];
	$posts = $xmls['indexresults'];
	$maxsize = $xmls['maximagesize'];
	$date = (string)$xmls['dateshow'];
	$customdate = !empty($xmls['customdate']) ? $xmls['customdate'] : '' ;
	$exclimit = $xmls['exclimit'];
	


	# onoff values
	$tog[] = $acc_info['texteditor'] == 'on' ? 'checked' : '';
	
	$togvalues = ['togsign','togcategories','togtags','togreadold','togptitle','togexc','unidates','togreadmore','tagstext'];
	$texteditor = $acc_info['texteditor'];
		foreach ($togvalues as $val)
			if ($xmls[$val] == 'on')
				$tog[] = 'checked';
			else
				$tog[] = '';

	
	# excerpt options
	if ($xmls['togexc'] == 'on')
		$selstyle = '';
	
	
	if ($xmls['togexc'] != 'on') {
		$exclimit .= '" tabindex="-1';
		$selstyle = 'style="opacity:.5;pointer-events:none"';
		$tog[8] .= ' tabindex="-2"';
	}
	
	
	# select-options
	$sortby = $xmls['sort'];
	

	# user accout info
	#$acc_info = get_account($_SESSION['userID']);
	$editorname = $acc_info['editorname'];
	$urlicon = $acc_info['urlicon'];
		
	
	# Date format
	# get dates from dates.xml
	# $php_dates supports older version. See phpdate_ in log.php
	$datesxml = simplexml_object('dates.xml','l',null);
	$php_dates = $datesxml->dateformats->dn == '' ? phpdate_($datesxml->dateformats->df) : phpdate($datesxml->dateformats->dn);

	
	array_push($php_dates,'none(turn off)','off');
	#$cssval = array_search((string)$date,$php_dates);


?>
	<div class="main">
		<h1 class="set">Settings </h1>
		<form action="general.php" method="post" id="MONform">
		<div class="center-container">
		<?php
		
		action_confirm();

		if(isset($_SESSION['usericon']))
			unset($_SESSION['usericon']);
		
		?>
			<div id="settingspage">

		
					
				<!-- Website settings -->
				<!-- Title -->
				<div class="sel">
					<label for="website-title" class="lab-5" title="Website title">Title</label><br>
					<span class="des">Your home page title.</span>
				</div>
					<input name="title" type="text" id="website-title" class="inp-2" title="Website title" value="<?php print $website_title ?>">
				<div class="clear-s"></div>




				<!-- Description -->
				<div class="sel">
					<label for="website-description" class="lab-5" title="Website description">Description</label><br>
					<span class="des">A description for your website.</span>
				</div>
				<textarea name="description" id="website-description" class="inp-2" title="Website description"><?php  print $website_description ?></textarea>
				<div class="clear"></div>

				
				
				
				<!-- Date format -->
				<div class="sel">
					<label for="dinp-1" class="lab-5" title="Choose a date format, included in dates.xml">Date</label><br>
					<span class="des">Choose a date format for your website, or completely remove from your posts. </span>
				</div>
				<div class="sel-r">
				<?php
				
				
				
				# Date select
				$off = array_pop($php_dates);
				$turnoff = array_pop($php_dates);
				$inp = '<input name="dateshow" class="monradio" type="radio" ';

				
				$cid=1;
				foreach($php_dates as $dopt) {

					if ($date == (string)$dopt)
						print $inp.'id="dinp-c" value="'.$dopt.'" checked><label for="dinp-c" title="Current date">'.date($dopt).'</label><br>'.PHP_EOL;
					else
						print $inp.'id="dinp-'.$cid.'" value="'.$dopt.'"><label for="dinp-'.$cid.'" title="Choose a date format">'.date($dopt).'</label><br>'.PHP_EOL; 

					$cid++;

				}
				
				$idoff = $date == $off || $date == $turnoff ? 'c' : $cid;
				
				
				print $inp.'id="dinp-'.$idoff.'" value="none(turn off)"><label for="dinp-'.$idoff.'" class="monradio" title="No date">None</label><br>'.PHP_EOL

				?>
				</div>
				<div class="clear"></div>
				
				
				<!-- Unique dates -->
				<div class="sel">
					<label for="onoff-7" class="lab-5" title="Unique dates">Unique dates</label><br>
					<span class="des">Similar dates can be skipped when displaying results. Uncheck to include them all.</span>
				</div>
				<input name="unidates" type="checkbox" id="onoff-7" class="moncheck" value="" title="" <?php print $tog[7] ?>>
				<label for="onoff-7" class="lab-5" title="Unique dates"></label>
				<div class="clear"></div>

	
				
				<!-- website results (Results in home page) -->
				<div class="sel">
					<label for="results-in-homepage" class="lab-5" title="Results per page">Results per page</label><br>
					<span class="des">The number of posts to appear per page, for index pages. Add a leading '0' to completely remove from home page.</span>
				</div>
				<input name="indexposts" type="text" id="results-in-homepage" class="inp-4" title="Results per page" maxlength="10" value="<?php print $posts ?>">
				<div class="clear"></div>
				

				<!-- Posting options -->
				<div class="lab-5"><h3>Post elements</h3></div>
				<span class="des"></span>
				<div class="clear-ss"></div>

				<div class="posts">

					<!-- Post title -->
					<div class="sel">
						<label for="onoff-5" class="lab-5" title="Post title">Title</label><br>
					</div>
					<input name="togptitle" type="checkbox" id="onoff-5" class="moncheck" value="" title="" <?php print $tog[5] ?>>
					<label for="onoff-5" class="lab-5" title="Post title"></label>
					<br>
					<br>
					
					
					<!-- Excerpt -->
					<div class="sel">
						<label for="onoff-6" class="lab-5" title="Excerpt">Excerpt</label><br>
					</div>
					<input name="togexc" type="checkbox" id="onoff-6" class="moncheck" value="" title="" onclick="exc()" <?php print $tog[6] ?>>
					<label for="onoff-6" class="lab-5" title="Excerpt"></label>
					<br>
					<br>
					
					
					<div id="excsel" <?php print $selstyle ?>>
						<!-- Excerpt value-->
						<div class="sel">
							<label for="excval" class="lab-5" title="Set an excerpt limit">Excerpt limit</label><br>
							<span class="des">Set a fixed limit for all posts, or leave empty to apply the limit set to each post. <br>(0 = show the whole post)</span>
						</div>
						<input name="exclim" type="text" id="excval" class="inp-7" title="Excerpt limit" maxlength="10" value="<?php print $exclimit ?>" placeholder="default">
						<div class="clear-ss"></div>
										
						

						<!-- Read more link -->
						<div class="sel">
							<label for="onoff-8" class="lab-5" title="Read more link">Read more link</label><br>
						</div>
						<input name="togreadmore" type="checkbox" id="onoff-8" class="moncheck" value="" title="" <?php print $tog[8] ?>>
						<label for="onoff-8" class="lab-5" title="Read more link"></label>
					</div>

					<script>
						function exc() {
							
							let a = document.getElementById('onoff-6');
							let b = document.getElementById('excval');
							let c = document.getElementById('excsel');
							let aa =document.getElementById('onoff-8');
							
							if (a.checked) {	 
								c.removeAttribute('style');
								b.removeAttribute('tabindex'); 
								aa.removeAttribute('tabindex'); 
							}
							
							else {
								c.setAttribute('style','opacity:.5;pointer-events:none');
								b.setAttribute('tabindex','-1');
								aa.setAttribute('tabindex','-2'); 

							}
							
						}
					</script>
					<br>
					<br>
					<br>
					
					<!-- Editor's name -->
					<div class="sel">
						<label for="onoff-1" class="lab-5" title="Sign posts with the Editor's name">Editor's name</label><br>
					</div>
					<input name="togsign" type="checkbox" id="onoff-1" class="moncheck" value="on" <?php print $tog[1] ?>>
					<label for="onoff-1" class="lab-5" title="Sign posts"></label>
					<br>
					<br>
					
					<!-- Categories -->
					<div class="sel">
						<label for="onoff-2" class="lab-5" title="Category">Category</label>
						<br>
					</div>
					<input name="togcategories" type="checkbox" id="onoff-2" class="moncheck" value="on" <?php print $tog[2] ?>>
					<label for="onoff-2" class="lab-5" title="Show categories"></label>
					<br>
					<br>
					<br>
					
					<!-- Tags -->
					<div class="sel">
						<label for="onoff-3" class="lab-5" title="Tags">Tags</label>
						<br>
					</div>
					<input name="togtags" type="checkbox" id="onoff-3" class="moncheck" value="on" <?php print $tog[3] ?>>
					<label for="onoff-3" class="lab-5" title="Show tags"></label>
					<br>
					<br>
					
					<!-- Tag links -->
					<div class="sel">
						<label for="onoff-31" class="lab-5" title="Unpublish Tag index pages">Unpublish Tag index pages</label>
						<span class="des">If Tags is on, will display them as plain text</span>
						<br>
					</div>
					<input name="tagstext" type="checkbox" id="onoff-31" class="moncheck" value="on" <?php print $tog[9] ?>>
					<label for="onoff-31" class="lab-5" title="Unpublish Tag index pages"></label>
					<div class="clear"></div>
				</div>
				
				
				<!-- Read old posts -->
				<div class="sel">
					<label for="onoff-4" class="lab-5" title="Go to next page(s) link">Go to next page link</label><br>
					<span class="des">Appears on your home page, when results per page are less than the total number of posts.</span>
				</div>
				<input name="togreadold" type="checkbox" id="onoff-4" class="moncheck" value="on" title="" <?php print $tog[4] ?>>
				<label for="onoff-4" class="lab-5" title="Go to next page link"></label>
				
				
				
				
				<div class="clear"></div>
				<div class="newoptions"></div>
				<div class="clear"></div>
				
				<!-- Control panel settings -->
				<!-- Upload image size -->
				<div class="sel">
					<label for="maxupload" class="lab-5" title="Max uploads size"> Max upload image size</label><br>
					<span class="des">Set the maximum size allowed for the uploaded files.</span>
				</div>
				<input name="maximagesize" type="text" id="maxupload" class="inp-7" title="File size in kilobytes" value="<?php print $maxsize ?>">kb
				<div class="clear"></div>
				<div class="newoptions"></div>
				<div class="clear"></div>


				<!-- User settings -->
				<!-- Text editor -->
				<div class="sel">
					<label for="onoff-0" class="lab-5" title="Text/HTML editor">Text/HTML editor</label><br>
					<span class="des">An old document "wysiwyg" editor for writing posts and pages.</span>
				</div>
				<input type="checkbox" name="texteditor" value="on" id="onoff-0" class="moncheck" title="Text editor" <?php print $tog[0] ?>>
				<label for="onoff-0" class="lab-5" title="Text/HTML editor"></label>
				<div class="clear"></div>
								

				<!-- Color theme -->
				<div class="sel">
					<label for="rd-1" class="lab-5" title="Control panel theme">Control panel theme</label><br>
					<span class="des"></span>
				</div>
				<div class="sel-r">
					<input name="theme" type="radio" id="rd-1" class="monradio" value="light"<?php if ($user_theme == 'light') print ' checked' ?>>
					<label id="lablight" for="rd-1" title="Light theme"><span id="lgh">abc</span></label>
					<input name="theme" type="radio" id="rd-3" class="monradio" value="dark"<?php if ($user_theme == 'cmdark') print ' checked' ?>>
					<label id="labdark" for="rd-3" title="Dark theme"><span id="drk">abc</span></label>
					<div class="clear-sm"></div>
					<div class="separator-sm"></div>
				</div>
				<div class="clear"></div>

				<!-- Editor name-->
				<div class="sel">
					<label for="editorname" class="lab-5" title="Editor name">Editor name</label><br>
					<span class="des">Appears instead of username.</span>
				</div>
				<input name="usereditorname" type="text" id="editorname" class="inp-76" title="Editor name" value="<?php print $editorname ?>" maxlength="80">
				<div class="clear"></div>



				<!-- User icon -->
				<div><span class="lab-5" title="User icon">Upload user icon</span><br>
					<span class="des">Upload an image file.</span>
				</div>
				
				
				<!-- Upload iframe -->
				<iframe src="upload_icon.php" name="user-image" id="user-image"></iframe>
				<div class="clear-ss"></div>
				
				
				<!-- Image file -->
				<p class="sel">
					<label for="usericon" class="lab-5" title="Image file">Image file</label><br>
					<span class="des">An image file from images folder (overrides upload user icon).</span>
				</p>
				<input id="usericon" type="text" name="urlicon" value="<?php print $urlicon ?>" class="inp-2" title="Image filename" placeholder="empty">				
				
				<div class="clear"></div>
				<div class="newoptions"></div>
				<div class="clear"></div>

				<!-- Refresh system -->
				<div class="sel">
					<span class="labspan" title="System check">System check</span><br>
					<span class="des">Auto scan and fix issues in your system.</span>
				</div>
				<a href="refresh.php" class="setlink" title="Start System check">Start system check &olarr;</a>
				<div class="clear"></div>
				

				
				<!-- Change login pasword -->
				<div class="sel">
					<span class="labspan" title="Login password">Login password</span><br>
					<span class="des">Create a new login password.</span>
				</div>
				<a href="password_change.php" class="setlink" title="Go to change password page">Change your login password &rarr;</a><br>
				<div class="clear"></div>
				
				
				
				<!-- Advanced -->
				<div class="sel">
				<a id="gotoadv" href="advanced.php" class="setlink" style="font-size:15px" title="Go to Advanced settings">Advanced settings &rarr;</a><br>
				</div>
				<div class="clear"></div>
				</div>
			</div>
		</form>
	</div>
</body>
</html>
