<?php


	# editpost.php
	# Delete a post file or change a 'Posted' or 'Posted/Not updated' file, to 'Draft'


	
	include_once 'data_connect.php';
	include_once 'log.php';

	
	
	# Change to draft
	if (isset($_GET['editfile']) && (count($_GET) == 1  || isset($_GET['max']))) {

		
		# This can be the 'nu' file, if the file has an 'nu' version
		$draft_file = $_GET['editfile'];
		$draft = simplexml_object($draft_file,'e','post');
		
		
		if (!is_array($draft)) {


			$creator = (string)$draft->postinfo->post->createdby;

			# The post must be created by the user or the user must have admin rights
			if (get_account($_SESSION['userID'])['rights'] == 'administrator' || $creator == $_SESSION['userID']) {

				
				$normal_file = str_replace('nu.xml','.xml',$draft_file);
				$type = (string)$draft->postinfo->post->type;
				
				
				if ($type != 'Draft') {
				
					$filename = (string)$draft->postinfo->post->filename;
					$path = (string)$draft->postinfo->post->path;

					$draft->postinfo->post->type = 'Draft';
					$draft->postinfo->post->path = '';
					$draft->postinfo->post->ptime = '';
					$draft->postinfo->post->modified = time();
					

					# Both normal & nu files are kept  - <= 2.4
					
					simplexml_object_save($normal_file,$draft,'post');
					
					if ($normal_file != $draft_file)
						simplexml_object_save($draft_file,$draft,'post');


					# Keep the latest saved version of a post - not working, see $normal_file - 2.4
					/*$nu_cfile = 'autosaves/content/'.$normal_file.'nu.htm';
					if (is_file($nu_cfile)) {
						$cnu_cfile = file_get_contents($nu_cfile);
						file_put_contents('autosaves/content/'.$normal_file.'.htm',$cnu_cfile);
					}*/


					
					# Change autosaves.xml -  2.4
					$heavy = simplexml_object('autosaves.xml','e','post');
		
					if (!is_array($heavy)) {
						
						
						$nbase = basename($normal_file,'.xml');
						$ubase = basename($draft_file,'.xml');
						
						$c=0;
						foreach($heavy->savedpost as $f) {
							if ($f->postinfo->post->file == $nbase) {
								foreach($draft->postinfo->post->children() as $tag => $val)
									$heavy->savedpost[$c]->postinfo->post->$tag = $val;
							
								break;
							}
							$c++;
						}
							
						# if 'nu' file exists search for entry
						if ($nbase != $ubase) {

							$c=0;
							foreach($heavy->savedpost as $f) {
								if ($f->postinfo->post->file == $ubase) {
									foreach($draft->postinfo->post->children() as $tag => $val)
										$heavy->savedpost[$c]->postinfo->post->$tag = $val;
									break;
								}
								$c++;
							}	
						}						

						simplexml_object_save('autosaves.xml',$heavy,'post');
						
					}

					$_SESSION['MONchanged_to_draft'] = true;
				}
				
				else	
					$_SESSION['MON_editpost_is_draft'] = true;
			}
		}
		
		else
			$_SESSION['MON_editpost_not_exist'] = true;	
	}


	else {

		# Delete
		if (isset($_GET['file'])) {

			$del = $_GET['file'];
			if (delete_post($del)) {
			
				$_SESSION['MONdeleted'] = true;
				
				$sum = get_log()['posts'];
				$sum -= 1;
				
				update_log('posts',$sum);
			
			}
		}
	}




	# File already changed to draft or deleted
	# Keep or remove some GET values
	$plink = '';

	# Existing GET parameters
	if (count($_GET) > 2) {

		# build get values
		# 'editfile' 'file' 'link'
		# We don't want to resend these values, so we remove them from $plink
		$param_not = ['editfile','file','link'/*,'max'*/];
		$x=0;
		foreach($_GET as $param=>$val) {

			if (!in_array($param,$param_not)) {
				$f = $x == 0 ? '?' : '&';
				$plink .= $f.$param.'='.$val;
				$x++;
			}
		}
	}
	

	header('Location:opensaved.php'.$plink)

?>
