<?php


	# Account editing
	


	# login
	include_once 'data_connect.php';
	include_once 'log.php';
	


	# user rights - admins only
	if (get_account($_SESSION['userID'])['rights'] != 'administrator') {
		header('Location:opensaved.php');
		exit();
	}
	


	# user rights - owner only can access own account edit page
	if (isset($_GET['userid'])) {
		
		$s = getXMLSettings();
		if ($_GET['userid'] == (string)$s['ownerid'] && $_SESSION['userID'] != (string)$s['ownerid']) {
			header('Location:accmanage.php');
			exit();
		}
	}




	
	# validate account info - only permitted users
	function username_validate() {
		
		
		# username must not be over 70 chars long
		# cannot register a username taken by another user
		# owner cannot remove own admin rights
		# nobody can edit owner account, except owner
		
		
		# username must not be too long or contain invalid characters
		$usrn = str_replace(['&','/','  ','$',',',':',';','=','<','>','%','{','}','^','~','[',']','`','\\','\'','"'],'',$_POST['username']);
		$usrn = htmlspecialchars(strip_tags($usrn),ENT_COMPAT);
		$usr = trim($usrn);
		if ((strlen($usr) < 3) || (strlen($usr) > 70))
			$er = 'account_username_not_valid';


		
		$s = getXMLSettings();


		# username already exists
		$usernames=[];
		$logfile = simplexml_object('log.xml','l',null);
		foreach($logfile->user as $user) {
			if (isset($_POST['hiddenid']) && $_POST['hiddenid'] != '')
				if (get_account($_POST['hiddenid'])['name'] == $user->name)
					continue;
			$usernames[] = $user->name;
		}
		

		if (array_search($usr,$usernames) !== false)
			$er = 'account_username_exists';



		# owner cannot remove own admin rights
		if ($_POST['accounttype'] != 'administrator' && $_POST['hiddenid'] == (string)$s['ownerid'])
			$er = 'account_could_not_modify';


		# owner only can edit own account
		if ($_POST['hiddenid'] == (string)$s['ownerid'] && $_SESSION['userID'] != (string)$s['ownerid'])
			$er = 'owner_account_could_not_modify';


		
		if (isset($er)) {
			$_SESSION[$er] = 1;
			return false;
		}
		else 
			return $usr;
		
	}



	# New account
	if (isset($_POST['password'])) {
		
		$usr = str_replace('  ','',$_POST['username']);
		$psw = str_replace(' ','',$_POST['password']);
		$typ = $_POST['accounttype'] == 'administrator' ? 'administrator' : 'author';
		$usr = username_validate();
			
		$info = htmlspecialchars(strip_tags($_POST['userinfo']),ENT_COMPAT);
		
		
		if ($usr === false) {
			header('Location:account.php');
			exit;
		}
		

		if  ($_POST['hiddenname'] == null)  {

			#create new account
			include 'set-cost.php';
			$pshs = password_hash($psw, PASSWORD_DEFAULT,["cost" => $cost]);

			$logsave = simplexml_object('log.xml','e',null);
			

			$id = md5(microtime());
			$newuser = $logsave->addChild('user',PHP_EOL.'  ');
			$newuser->addChild('name',$usr);
			$newuser->addChild('pshs',$pshs);
			$newuser->addChild('rights',$typ);
			$newuser->addChild('login','none');
			$newuser->addChild('ip',' ');
			$newuser->addChild('created',time());
			$newuser->addChild('icon','../images/userimage.png');
			$newuser->addChild('editorname',$usr);
			$newuser->addChild('texteditor','on');
			$newuser->addChild('theme','light');
			$subres = $newuser->addChild('results','');
			$subres->addChild('posts','5');

			if ($typ == 'administrator')
				$subres->addChild('pages','5');

			$subres->addChild('images','5');
			$newuser->addChild('userID',$id);
			$newuser->addChild('userinfo',$info);

			simplexml_object_save('log.xml',$logsave,null);


			$_SESSION['account_created'] = true;
			header('Location:accmanage.php');
			exit;

		}
	}
	
	
	
	# Edit account
	else {
	
		if (isset($_POST['username'])) {
	
		
			if (isset($_POST['hiddenname'])) {
			
				$stg = simplexml_object('settings.xml','l',null);
				$usr = username_validate();

				if ($usr === false) {
					header('Location:accmanage.php');
					exit;
				}
				
				$_POST['userinfo'] = htmlspecialchars(strip_tags($_POST['userinfo']),ENT_COMPAT);
				$_POST['username'] = $usr;
				$_POST['accounttype'] = $_POST['accounttype'] == 'administrator' ? 'administrator' : 'author';
				
				# update account
				$updt = update_account($_POST['hiddenid'],'set');
				
				if ($updt === false)
					$_SESSION['account_missing'] = true;
				
				
				else {
					
					# if we confirm account update was succesful, update the username in the session
					if ($_SESSION['userID'] == $_POST['hiddenid'])
						$_SESSION['username'] = $usr;
					
					$_SESSION['account_modified'] = true;
					
				}
			}

			header('Location:accmanage.php');
			exit;
		
		}
	}


	if (isset($_GET['userid']) ) {
		if (empty(get_account($_GET['userid']))) {
			header('Location: accmanage.php');
			exit;
		}
		else
			$heading = 'Edit account';
	}
	
	else
		$heading = 'Create account'
		
		
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title><?php echo $heading ?></title>
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<link rel="stylesheet" type="text/css" href="cmsavebutton.css">
<?php
	$cssid = '#accounts';
	include 'csstheme.php';
	print '<style>#accounts+.dpsub:after{content:"'.$heading.'"} '.$curval.'</style>' ?>
</head>
<body>
<?php


	# panel
	include 'mypanel.php';
	action_confirm()

?>
	<div class="main subpage">
		<h1 class="inbl"><a href="accmanage.php" title="Back to Accounts">&larr; </a> <?php echo $heading ?></h1>
		<div class="center-container account-container subcontainer">
			<form action="account.php" method="POST" name="acc" id="MONform">
				<!-- Current username hidden -->
				<input name="hiddenname" type="text" value="<?php if (isset($_GET['userid'])) print get_account($_GET['userid'])['name'] ?>" hidden>
				<!-- Current user id hidden -->
				<input name="hiddenid" type="text" value="<?php if (isset($_GET['userid'])) print $_GET['userid'] ?>" hidden>
				
				<!-- Username -->
				<div class="sel">
					<label for="account-username">Username</label>
				</div>
				<input name="username" type="text" id="account-username" class="inp-2" title="Username" value="<?php if (isset($_GET['userid'])) print get_account($_GET['userid'])['name'] ?>" placeholder="username">
				<!-- Password -->
				<?php if (!isset($_GET['userid'])) : ?>
				
				<div class="clear"></div>
				<div class="sel">
					<label for="account-password">Password</label>
				</div>
				<input name="password" type="text" id="account-password" class="inp-2" title="Password" value="" placeholder="password">						
				<?php endif ?>
				
				<div class="clear-h"></div>
				
				<!-- Account type -->
				<div class="sel">
					<label for="select-type" class="label-acc">Account type</label>
				</div>
				<select name="accounttype" id="select-type">
					
					<?php


					if (isset($_GET['userid'])) {
						
						$cur_owner = $xmls['ownerid'];

						if ($_GET['userid'] == $cur_owner)
							print '<option>administrator</option>'.PHP_EOL;

						else {

							$type = get_account($_GET['userid'])['rights'];
							print '<option>'.$type.'</option>'.PHP_EOL;

							
							if ($type == 'administrator')
								print '<option>author</option>'.PHP_EOL;
							else	
								print '<option>administrator</option>'.PHP_EOL;

						}
					
					}
					
					else 
						print '<option>administrator</option>'.PHP_EOL.'<option>author</option>'.PHP_EOL
					
				?>
				</select>
				<div class="clear-m"></div>
				<div class="clear"></div>
				<div class="clear"></div>
		
				
				<!-- User info -->
				<div class="sel">
					<label for="userinf">User information</label>
				</div>
				<textarea id="userinf" name="userinfo" class="inp-2" placeholder="User information"><?php 
				
				if (isset($_GET['userid']))
					if (isset(get_account($_GET['userid'])['userinfo']))
						echo get_account($_GET['userid'])['userinfo']

				?></textarea>
				<div class="clear-m"></div>
				<div class="clear"></div>
				<!--<input type="submit" class="stylish-button" value="Submit account" title="Submit account">-->
				
				
			</form>
		</div>
	</div>
</body>
</html>
