<?php

	
	# Manage all user accounts



	# login
	include_once 'data_connect.php';
	include_once 'log.php';
	


	# user rights - admins only
	if (get_account($_SESSION['userID'])['rights'] != 'administrator') {
		header('Location:opensaved.php');
		exit;
	}


	$settings = simplexml_object('settings.xml','e',null);
	$ownerid = $settings->general->ownerid;
	$myid = $_SESSION['userID'];
	


	if (isset($_GET['userid'])) {
		
		# Owner cannot be deleted
		if ($ownerid == $_GET['userid'])
			$_SESSION['account_owner_del'] = true;


		# Delete
		elseif (update_account($_GET['userid'],'delete') !== false) {
			#self delete is possible
			if ($_SESSION['userID'] == $_GET['userid']) {
				header('Location:login.php');
				exit;
			}
			
			$_SESSION['account_deleted'] = true;
		}
		
		header('Location:accmanage.php');
		exit;		
		
	}
	

	# User to owner
	if (isset($_GET['uto'])) {
		
		$newow = $_GET['uto'];
		$newowacc = get_account($newow);
		
		if ($newowacc['rights'] == 'administrator' && $ownerid == $_SESSION['userID']) {
			
			if ($newowacc['name'] != $ownerid) {

				$settings->general->ownerid = $newow;

				# Save
				simplexml_object_save('settings.xml',$settings,null);
				$_SESSION['account_set_to_owner'] = true;
			}
		}
		
		else
		$_SESSION['account_cannot_set'] = true;
		
		header('Location:accmanage.php');
		exit;
	}


?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Accounts</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" type="text/css" href="cmstyle.css">
<?php 
	
	$cssid = '#accounts';
	include 'csstheme.php';
	print '<style>'.$curval.'</style>' ?>

<script type="text/javascript">
function conf(){
	return confirm('Delete this account?');
}
function confs(){
	return confirm('Make this user the owner? You will no longer be the owner and you cannot undo this action.');
}
</script>
</head>
<body>
<?php


	# panel
	include 'mypanel.php';
	action_confirm()



?>
	<div class="main">
		<h1>Accounts <a class="newpostbut" href="account.php" id="newaccount" title="Create a user account">
		<span class="addnew">+</span>&nbsp;Create a user account</a></h1>

		<div id="main-container">
			<div class="results savedusers">
					
		<?php


		$logfile = simplexml_object('log.xml','l',null);
		$acc_arr = [];

		foreach($logfile->user as $user) {
			
			$uicon = $user->urlicon != '' ? '../images/'.$user->urlicon : $user->icon;
			$acc_arr[(string)$user->userID] = [(string)$user->name,(string)$user->rights,(string)$user->login,(string)$uicon,(string)$user->status,(string)$user->userinfo,(string)$user->editorname];

		}
		
		
		# my account
		$myacc = [$myid=>$acc_arr[$myid]];
		

		if (isset($_GET['account']))
		
			if ($_GET['account'] == 'author' || $_GET['account'] == 'administrator') {	
			
				$acval = $_GET['account'];
				foreach($acc_arr as $k=>$v)
					if ($v[1] != $acval)
						unset($acc_arr[$k]);
			}
		
		
		# array containing accounts, putting owner account first
		$acc_arr = $myacc+$acc_arr;
		
		

		$c=0;
		foreach($acc_arr as $key=>$val) {
			
			
			$name = $val[0];
			$rights = $val[1];
			$login = $val[2];
			$img = $val[3];
			$iusr = $val[5];
			$userid = $key;
			$editor = $val[6];



			# account options html
			# edit account
			$edit = '<a href="account.php?userid='.$userid.'" title="Edit account" class="options-button">Edit account</a>'.PHP_EOL;

			# delete
			$delacc = '<a href="accmanage.php?userid='.$userid.'" class="options-button del-op-but" title="Delete account" onclick="return conf(this)">Delete</a>'.PHP_EOL;

			# make owner
			$cto = '<a href="accmanage.php?uto='.$userid.'" class="options-button" title="Make owner" onclick="return confs(this)">Make owner</a>';



			# last login
			$ftime = $login == 'none' ? 'No data' : date_form(strtotime($login));
	
			# owner indicator icon
			$ownericon = $userid == (string)$ownerid ? '<img class="ownericon" title="Owner" src="images/owner.gif">' : '';
		
		
		
			$savedoff = '';

			if ($myid == (string)$ownerid)
			
			
				if ($myid == $userid)
					$options = $edit;
					
				elseif($rights == 'administrator')
					$options = $edit.$delacc.$cto;
				
				else
					$options = $edit.$delacc;
			
				
			else 
			
				if ($userid == (string)$ownerid) {
					$options = '';
					$savedoff = ' savedoff';
					$ftime = '';
				}
				
				else
					$options = $edit.$delacc;
			
			
			
			$acc_date = date("H:i",strtotime($login));
			
			if ($login == 'none' )
				$acc_date = 'not found';
			
			
			# separator
			$sep = $c == 0 ? '<div class="newoptions" style="font-size:12px;margin:5px 0 60px 57px"></div>
			<div class="pbar pbaraccounts">
			<span id="pbar-title" title="Username">Username</span>
			<span class="lastmobar" title="Last login date">Last login</span>
			<span class="acctype" title="Account type">Type</span>
			<span class="acctype" title="Editor name">Editor name</span>
			</div>	' : '';
			
			
			if ($val[4] != 'del')

				echo '<div class="savedfile'.$savedoff.'">
				<span class="account-username"><img src="'.$img.'">'.$name.'</span>
				<div class="account-description">'.$iusr.'</div>
				<div class="post-options">'.$options.'</div>
				<div class="last-login" title="Last login - '.$acc_date.'">'.$ftime.'</div>
				<div class="type" style="margin-right:40px" title="Account type"><span><a href="?account='.$rights.'">'.$rights.'</a></span></div>
				<div class="type" title="Editor name"><span>'.$editor.'</span></div>
				'.$ownericon.'
				</div>'.$sep;
			
			
			$c++;
		}
	?>
			</div>
		</div>
	</div>
</body>
</html>
